<?php

declare(strict_types=1);

use Points\Core\Total;
use Points\Core\Points;
use Points\Core\Amount;

class Points_Core_Model_Schema_QuoteTotalAvailable extends Points_Core_Model_Schema_QuoteTotal {
    /**
     * @var Points
     */
    protected $available;

    /**
     * @param Array<Total> $totals
     * @param callable(Total): Array<Amount> $callback
     */
    public function __construct(array $totals, $callback, Points $available) {
        parent::__construct($totals, $callback);

        $this->available = $available;
    }

    public function getIncVat(): int {
        return (int)min(parent::getIncVat(), $this->available->getTotalInclTax());
    }

    public function getExVat(): int {
        return (int)min(parent::getExVat(), $this->available->getTotalExclTax());
    }

    public function getVat(): int {
        return (int)min(parent::getVat(), $this->available->getTax());
    }
}
