<?php

declare(strict_types=1);

use Points\Core\Total;
use Points\Core\Amount;

class Points_Core_Model_Schema_QuoteTotal {
    /**
     * @var Array<Total>
     */
    protected $totals;

    /**
     * @var callable(Total): Array<Amount>
     */
    protected $callback;

    /**
     * @param Array<Total> $totals
     * @param callable(Total): Array<Amount> $callback
     */
    public function __construct(array $totals, $callback) {
        $this->totals = $totals;
        $this->callback = $callback;
    }

    public function getIncVat(): int {
        return (int)ceil(array_sum(array_map(function(Total $t) {
            return array_sum(array_map("Points\Core\Amount::totalInclTax", ($this->callback)($t)));
        }, $this->totals)));
    }

    public function getExVat(): int {
        return (int)ceil(array_sum(array_map(function(Total $t) {
            return array_sum(array_map("Points\Core\Amount::totalExclTax", ($this->callback)($t)));
        }, $this->totals)));
    }

    public function getVat(): int {
        return (int)ceil(array_sum(array_map(function(Total $t) {
            return array_sum(array_map("Points\Core\Amount::tax", ($this->callback)($t)));
        }, $this->totals)));
    }
}
