<?php

declare(strict_types=1);

use Points\Core\Amount;
use Points\Core\Extension\Quote;
use Points\Core\Total;

class Points_Core_Model_Schema_QuotePointTotal {
    /**
     * @var Quote
     */
    protected $quote;

    public function __construct(Mage_Sales_Model_Quote $quote) {
        /**
         * @var Quote $quote
         */
        $this->quote = $quote;
    }

    /**
     * @psalm-suppress RedundantCast
     */
    public function getIncVat(): int {
        return (int)($this->quote->getPointsPoints() + $this->quote->getPointsTaxPoints());
    }

    public function getExVat(): int {
        return (int)$this->quote->getPointsPoints();
    }

    public function getVat(): int {
        return (int)$this->quote->getPointsTaxPoints();
    }
}
