<?php

declare(strict_types=1);

use Points\Core\Total;
use Points\Core\Amount;
use Points\Core\Extension\Order;

class Points_Core_Model_Schema_OrderPointTotal {
    /**
     * @var Order
     */
    protected $order;

    public function __construct(Mage_Sales_Model_Order $order) {
        /**
         * @var Order $order
         */
        $this->order = $order;
    }

    /**
     * @psalm-suppress RedundantCast
     */
    public function getIncVat(): int {
        return (int)($this->order->getPointsPoints() + $this->order->getPointsTaxPoints());
    }

    public function getExVat(): int {
        return (int)$this->order->getPointsPoints();
    }

    public function getVat(): int {
        return (int)$this->order->getPointsTaxPoints();
    }
}
