<?php

declare(strict_types=1);

class Points_Core_Model_Product_Price_Item {
    /**
     * @var Points_Core_Model_Product_Price|Points_Core_Model_Product_Index
     */
    protected $price;

    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    /**
     * @param Points_Core_Model_Product_Price|Points_Core_Model_Product_Index $price
     */
    public function __construct(
        Mage_Catalog_Model_Product $product,
        $price
    ) {
        $this->product = $product;
        $this->price = $price;
    }

    public function getId(): string {
        return $this->price->getType();
    }

    public function getLabel(array $args, MageQL_Core_Model_Context $ctx): string {
        $provider = Mage::helper("points_core")->getTypeProvider($ctx->getStore(), $this->price->getType());

        return $provider ? $provider->getLabel($ctx->getStore()) : "";
    }

    public function getPrice(): Points_Core_Model_Product_Price_Item_Price {
        return new Points_Core_Model_Product_Price_Item_Price(
            $this->product,
            (int)$this->price->getPrice()
        );
    }

    public function getMinimum(): Points_Core_Model_Product_Price_Item_Price {
        return new Points_Core_Model_Product_Price_Item_Price(
            $this->product,
            (int)$this->price->getMinPrice()
        );
    }

    public function getMaximum(): Points_Core_Model_Product_Price_Item_Price {
        $price = $this->price->getMaxPrice() ?: $this->price->getPrice();

        return new Points_Core_Model_Product_Price_Item_Price(
            $this->product,
            (int)$price
        );
    }

    public function getMaximumCurrency(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        $percent = $this->price->getPrice() > 0 ?
            ($this->price->getPrice() - (int)$this->price->getMinPrice()) / $this->price->getPrice() :
            1;

        return new MageQL_Catalog_Model_Product_Price($this->product, $this->product->getFinalPrice() * $percent);
    }
}
