<?php

declare(strict_types=1);

class Points_Core_Block_Adminhtml_Catalog_Product_Edit extends Mage_Adminhtml_Block_Widget {
    public function __construct() {
        parent::__construct();
        $this->setTemplate("points_core/product/edit.phtml");
    }

    public function getCurrencies(): array {
        $helper = Mage::helper("points_core");
        $storeId = $this->getRequest()->getParam("store");
        $store = Mage::app()->getStore($storeId);
        $providers = $helper->getTypeProviders($store);

        return array_map(function($provider, $key) {
            return [
                "id" => $key,
                "label" => $provider->getLabel(Mage::app()->getStore()),
            ];
        }, $providers, array_keys($providers));
    }

    public function getBaseValues(bool $baseStore = false): array {
        $helper = Mage::helper("points_core");
        $product = Mage::registry("product");
        $storeId = $baseStore ? 0 : $this->getRequest()->getParam("store");
        $store = Mage::app()->getStore($storeId);
        $providers = $helper->getTypeProviders($store);
        $collection = Mage::getResourceModel("points_core/product_price_collection");
        $rows = [];

        $collection->filterByProduct($product);
        $collection->filterByStore($store);
        $collection->filterByNotLoggedInCustomerGroup();

        $data = $collection->getItems();

        foreach($providers as $type => $provider) {
            $item = null;

            foreach($data as $i) {
                if($i->getType() === $type) {
                    $item = $i;

                    break;
                }
            }

            $rows[] = [
                "id" => $item ? $item->getId() : null,
                "type" => $type,
                "store_id" => $store->getId(),
                "customer_group_id" => Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
                "label" => $provider->getLabel(Mage::app()->getStore()) ?: $type,
                "price" => $item ? $item->getPrice() : null,
                "min_price" => $item ? $item->getMinPrice() : null,
                "max_price" => $item ? $item->getMaxPrice() : null,
            ];
        }

        return $rows;
    }

    public function getCustomerGroupValues(): array {
        $helper = Mage::helper("points_core");
        $product = Mage::registry("product");
        $storeId = $this->getRequest()->getParam("store");
        $store = Mage::app()->getStore($storeId);
        $providers = $helper->getTypeProviders($store);
        $collection = Mage::getResourceModel("points_core/product_price_collection");
        $rows = [];

        $collection->filterByProduct($product);
        $collection->filterByStore($store);
        $collection->filterByCustomerGroups();

        $data = $collection->getItems();

        foreach($data as $item) {
            $type = null;
            $provider = null;

            foreach($providers as $t => $p) {
                if($item->getType() === $type) {
                    $type = $t;
                    $provider = $p;

                    break;
                }
            }

            $rows[] = [
                "id" => $item->getId(),
                "type" => $type,
                "store_id" => $store->getId(),
                "customer_group_id" => $item->getCustomerGroupId(),
                "label" => ($provider ? $provider->getLabel(Mage::app()->getStore()) : null) ?: $type,
                "price" => $item->getPrice(),
                "min_price" => $item->getMinPrice(),
                "max_price" => $item->getMaxPrice(),
            ];
        }

        return $rows;
    }

    public function canDisplayUseDefault(): bool {
        return $this->getRequest()->getParam("store") > 0;
    }

    public function getScopeLabel(): string {
        if(empty($this->getRequest()->getParam("store"))) {
            return Mage::helper('adminhtml')->__('[GLOBAL]');
        }
        else {
            return Mage::helper('adminhtml')->__('[STORE VIEW]');
        }
    }
}
