<?php

declare(strict_types=1);

namespace Points\Core\Extension;

use Mage_Sales_Model_Quote;

/**
 * @psalm-suppress PropertyNotSetInConstructor
 *
 * Amounts never include tax.
 *
 * Points to spend on quote:
 *
 * @method ?string getPointsType()
 * @method void setPointsType(?string $type)
 * @method int getPointsPoints()
 * @method void setPointsPoints(int $points)
 * @method int getPointsTaxPoints()
 * @method void setPointsTaxPoints(int $points)
 *
 * Amount of currency excluding tax corresponding to the points spent:
 *
 * @method float getBasePointsAmount()
 * @method void setBasePointsAmount(float $amount)
 * @method float getPointsAmount()
 * @method void setPointsAmount(float $amount)
 *
 * Amount of currency for tax corresponding to the points spent, is not included
 * in tax total or grand total (add to grand total along with positive value of
 * points amount to get quote value in currency):
 *
 * @method float getBasePointsTaxAmount()
 * @method void setBasePointsTaxAmount(float $amount)
 * @method float getPointsTaxAmount()
 * @method void setPointsTaxAmount(float $amount)
 *
 * Total value in points for this quote (only counts products which have a point
 * price):
 *
 * @method int getPointsPointsTotal()
 * @method void setPointsPointsTotal(int $value)
 * @method int getPointsTaxPointsTotal()
 * @method void setPointsTaxPointsTotal(int $value)
 *
 * Shipping value in points if shipping can be paid using points:
 *
 * @method ?int getPointsShippingPointsValue()
 * @method void setPointsShippingPointsValue(?int $value)
 * @method ?int getPointsShippingTaxPointsValue()
 * @method void setPointsShippingTaxPointsValue(?int $value)
 *
 * Amount of the currency value of this quote which is included in the point
 * calculation:
 *
 * @method float getPointsAmountIncluded()
 * @method void setPointsAmountIncluded(float $amount)
 * @method float getPointsTaxAmountIncluded()
 * @method void setPointsTaxAmountIncluded(float $amount)
 *
 * Amount of the currency value of this quote which is EXCLUDED in the point
 * calculation:
 *
 * @method float getPointsAmountExcluded()
 * @method void setPointsAmountExcluded(float $amount)
 * @method float getPointsTaxAmountExcluded()
 * @method void setPointsTaxAmountExcluded(float $amount)
 *
 * Non-persistent:
 *
 * @method void setPointsWanted(int $points)
 * @method ?int getPointsWanted()
 * @method bool hasPointsWanted()
 * @method void unsPointsWanted()
 * @method void setPointsWantedIncludesTax(bool $includesTax)
 * @method ?bool getPointsWantedIncludesTax()
 * @method bool hasPointsWantedIncludesTax()
 * @method void unsPointsWantedIncludesTax()
 */
class Quote extends Mage_Sales_Model_Quote {
}
