<?php

declare(strict_types=1);

namespace Points\Core\Extension;

use Mage_Sales_Model_Order;

/**
 * @psalm-suppress PropertyNotSetInConstructor
 *
 * Amounts never include tax.
 *
 * Points spent on order:
 *
 * @method ?string getPointsType()
 * @method void setPointsType(?string $type)
 * @method int getPointsPoints()
 * @method void setPointsPoints(int $points)
 * @method int getPointsTaxPoints()
 * @method void setPointsTaxPoints(int $points)
 *
 * Amount of currency excluding tax corresponding to the points spent:
 *
 * @method float getBasePointsAmount()
 * @method void setBasePointsAmount(float $amount)
 * @method float getPointsAmount()
 * @method void setPointsAmount(float $amount)
 *
 * Amount of currency for tax corresponding to the points spent, is not included
 * in tax total or grand total (add to grand total along with positive value of
 * points amount to get order value in currency):
 *
 * @method float getBasePointsTaxAmount()
 * @method void setBasePointsTaxAmount(float $amount)
 * @method float getPointsTaxAmount()
 * @method void setPointsTaxAmount(float $amount)
 *
 * Total value in points for this order (only counts products which have a point
 * price):
 *
 * @method int getPointsPointsTotal()
 * @method void setPointsPointsTotal(int $value)
 * @method int getPointsTaxPointsTotal()
 * @method void setPointsTaxPointsTotal(int $value)
 *
 * Shipping value in points if shipping can be paid using points:
 *
 * @method ?int getPointsShippingPointsValue()
 * @method void setPointsShippingPointsValue(?int $value)
 * @method ?int getPointsShippingTaxPointsValue()
 * @method void setPointsShippingTaxPointsValue(?int $value)
 *
 * Amount of the currency value of this order which is included in the point
 * calculation:
 *
 * @method float getPointsAmountIncluded()
 * @method void setPointsAmountIncluded(float $amount)
 * @method float getPointsTaxAmountIncluded()
 * @method void setPointsTaxAmountIncluded(float $amount)
 *
 * Amount of the currency value of this order which is EXCLUDED in the point
 * calculation:
 *
 * @method float getPointsAmountExcluded()
 * @method void setPointsAmountExcluded(float $amount)
 * @method float getPointsTaxAmountExcluded()
 * @method void setPointsTaxAmountExcluded(float $amount)
 *
 * These values do not include tax:
 *
 * @method int getPointsPointsInvoiced()
 * @method void setPointsPointsInvoiced(int $amount)
 * @method int getPointsTaxPointsInvoiced()
 * @method void setPointsTaxPointsInvoiced(int $amount)
 * @method float getPointsAmountInvoiced()
 * @method void setPointsAmountInvoiced(float $amount)
 * @method float getBasePointsAmountInvoiced()
 * @method void setBasePointsAmountInvoiced(float $amount)
 * @method float getPointsTaxAmountInvoiced()
 * @method void setPointsTaxAmountInvoiced(float $amount)
 * @method float getBasePointsTaxAmountInvoiced()
 * @method void setBasePointsTaxAmountInvoiced(float $amount)
 *
 * @method int getPointsPointsRefunded()
 * @method void setPointsPointsRefunded(int $amount)
 * @method int getPointsTaxPointsRefunded()
 * @method void setPointsTaxPointsRefunded(int $amount)
 * @method float getPointsAmountRefunded()
 * @method void setPointsAmountRefunded(float $amount)
 * @method float getBasePointsAmountRefunded()
 * @method void setBasePointsAmountRefunded(float $amount)
 * @method float getPointsTaxAmountRefunded()
 * @method void setPointsTaxAmountRefunded(float $amount)
 * @method float getBasePointsTaxAmountRefunded()
 * @method void setBasePointsTaxAmountRefunded(float $amount)
 */
class Order extends Mage_Sales_Model_Order {
}
