<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$productIndexTable = $conn->newTable($installer->getTable("points_core/product_index"));

$productIndexTable->addColumn("entity_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "identity" => true,
    "unsigned" => true,
    "nullable" => false,
    "primary" => true,
], "Point index entity id");
$productIndexTable->addColumn("website_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
], "Website Id this index row corresponds to");
$productIndexTable->addColumn("customer_group_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
], "Customer Group this index row corresponds to");
$productIndexTable->addColumn("type", Varien_Db_Ddl_Table::TYPE_TEXT, 64, [
    "nullable" => false,
], "Point type code");
$productIndexTable->addColumn("product_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "unsigned" => true,
    "nullable" => false,
], "Product entity id");
$productIndexTable->addColumn("price", Varien_Db_Ddl_Table::TYPE_INTEGER, 11, [
    "nullable" => false,
]);
$productIndexTable->addColumn("min_price", Varien_Db_Ddl_Table::TYPE_INTEGER, 11, [
    "nullable" => false,
    "default" => 0,
]);
$productIndexTable->addColumn("max_price", Varien_Db_Ddl_Table::TYPE_INTEGER, 11, [
    "nullable" => false,
]);
$productIndexTable->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
], "Created at");
$productIndexTable->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
], "Updated at");

$productIndexTable->addIndex(
    $installer->getIdxName("points_core/product_index", ["website_id", "customer_group_id", "product_id", "type"], Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE),
    ["website_id", "customer_group_id", "type", "product_id"],
    ["type" => Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE]
);

$productIndexTable->addForeignKey(
    $installer->getFkName("points_core/product_index", "product_id", "catalog/product", "entity_id"),
    "product_id",
    $installer->getTable("catalog/product"),
    "entity_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);
$productIndexTable->addForeignKey(
    $installer->getFkName("points_core/product_index", "website_id", "core/website", "website_id"),
    "website_id",
    $installer->getTable("core/website"),
    "website_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);
$productIndexTable->addForeignKey(
    $installer->getFkName("points_core/product_index", "customer_group_id", "customer/customer_group", "customer_group_id"),
    "customer_group_id",
    $installer->getTable("customer/customer_group"),
    "customer_group_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);

$productIndexTable->setOption("type", "InnoDB");
$productIndexTable->setOption("charset", "utf8");

$conn->createTable($productIndexTable);

$installer->endSetup();
