<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\Total\Shipping;
use Points\Core\Points;
use Points\Core\Currency;

class QuoteShipping {
    /**
     * @var Shipping<int>
     */
    protected $total;

    /**
     * @param Shipping<int> $total
     */
    public function __construct(
        Shipping $total
    ) {
        $this->total = $total;
    }

    public function getPoints(): ?QuoteShippingPoints {
        $points = $this->total->getPoints();

        if( ! $points) {
            return null;
        }

        return new QuoteShippingPoints($points);
    }

    public function getCurrency(): QuoteShippingCurrency {
        return new QuoteShippingCurrency($this->total);
    }
}
