<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL\Context;
use Points\Core\Amount;

class PointsTotal implements TotalInterface {
    /**
     * @var Amount<int>
     */
    private $amount;

    /**
     * @param Amount<int> $amount
     */
    public function __construct(Amount $amount) {
        $this->amount = $amount;
    }

    public function getIncVat(
        Context $ctx
    ): int {
        return $this->amount->getTotalInclTax();
    }

    public function getExVat(
        Context $ctx
    ): int {
        return $this->amount->getTotalExclTax();
    }

    public function getVat(
        Context $ctx
    ): int {
        return $this->amount->getTax();
    }

    public function getTotalAndTax(bool $incVat): int {
        return $this->amount->getTotalAndTax($incVat);
    }
}

