<?php

declare(strict_types=1);

namespace Points\Core\Total;

use Points\Core\Points;
use Points\Core\Amount;

/**
 * @template-covariant T of float|int
 */
interface TotalInterface {
    /**
     * @return ?PointsInterface<T>
     */
    public function getPoints();
    /**
     * Product price accounting for discount.
     *
     * @return Amount<float>
     */
    public function getPrice();
    /**
     * The total discount on this total.
     *
     * NOTE: Does not a by min/max/selected points.
     *
     * @return Amount<float>
     */
    public function getDiscount();
    /**
     * @template U of float|int
     * @param ?PointsInterface<U> $points
     * @return self
     */
    public function withPoints($points);
    /**
     * The scaled row total after a selected number of points has been calculated.
     * Null means no points applied.
     *
     * @return ?Amount<float>
     */
    public function getPointTotalAmount();
    /**
     * Adds a calculated scaled row total based on selected points.
     *
     * @param ?Amount<float> $pointTotalAmount
     * @return self
     */
    public function withPointTotalAmount($pointTotalAmount);
}
