<?php

declare(strict_types=1);

namespace Points\Core\Total;

use RuntimeException;
use Mage_Tax_Model_Config;
use Points_Core_Model_Product_Price;
use Points\Core\Amount;

/**
 * @implements PointsInterface<int>
 */
class QuoteAddressPoints implements PointsInterface {
    /**
     * @var list<TotalInterface<int>>
     */
    private $totals;
    /**
     * @var bool
     */
    private $incVat;

    /**
     * @param list<TotalInterface<int>> $totals
     */
    public function __construct(array $totals, bool $incVat) {
        $this->totals = $totals;
        $this->incVat = $incVat;
    }

    public function getValue(): Amount {
        /** @var Amount<int> */
        $value = new Amount(0, $this->incVat, 0);

        foreach($this->totals as $total) {
            $points = $total->getPoints();

            if($points) {
                $value = $value->add($points->getValue());
            }
        }

        return $value;
    }

    public function getMin(): Amount {
        /** @var Amount<int> */
        $min = new Amount(0, $this->incVat, 0);

        foreach($this->totals as $total) {
            $points = $total->getPoints();

            if($points) {
                $min = $min->add($points->getMin());
            }
        }

        return $min;
    }

    public function getMax(): Amount {
        /** @var Amount<int> */
        $max = new Amount(0, $this->incVat, 0);

        foreach($this->totals as $total) {
            $points = $total->getPoints();

            if($points) {
                $max = $max->add($points->getMax());
            }
        }

        return $max;
    }

    public function getDiscount(): Amount {
        /** @var Amount<int> */
        $discount = new Amount(0, $this->incVat, 0);

        foreach($this->totals as $total) {
            $points = $total->getPoints();

            if($points) {
                $discount = $discount->add($points->getDiscount());
            }
        }

        return $discount;
    }

    /**
     * @return Amount<int>
     */
    public function getSelected(): Amount {
        /** @var Amount<int> */
        $selected = new Amount(0, $this->incVat, 0);

        foreach($this->totals as $total) {
            /** @var null|ItemPoints|ShippingPoints|SpreadPoints|SelectedPoints */
            $points = $total->getPoints();

            if($points) {
                if( ! $points instanceof SelectedPoints) {
                    throw new RuntimeException(sprintf(
                        "%s: Attempted to obtain selected point before calculating it",
                        __METHOD__
                    ));
                }

                $selected = $selected->add($points->getSelected());
            }
        }

        return $selected;
    }
}
