<?php

declare(strict_types=1);

namespace Points\Core\Total;

use Points\Core\Amount;

/**
 * @template-covariant T as float|int
 */
interface PointsInterface {
    /**
     * Returns the total value in points for this row, discounts are taken
     * into account.
     *
     * @return Amount<T>
     */
    public function getValue(): Amount;
    /**
     * Returns the minimum amount of points possible to spend on this row,
     * discounts are taken into account.
     *
     * @return Amount<T>
     */
    public function getMin(): Amount;
    /**
     * Returns the maximum amount of points possible to spend on this row,
     * discounts are taken into account.
     *
     * @return Amount<T>
     */
    public function getMax(): Amount;
    /**
     * Returns the value of the applied discount on this item in points.
     *
     * NOTE: Does not account for any selected points, it is the total value of
     *       the applied discount in points.
     *
     * @return Amount<T>
     */
    public function getDiscount(): Amount;
}
