<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\Currency;
use Points\Core\Points;
use Points\Core\Total\PointsInterface;

class QuoteShippingPoints {
    /**
     * @var PointsInterface<int>
     */
    protected $points;

    /**
     * @param PointsInterface<int> $points
     */
    public function __construct(PointsInterface $points) {
        $this->points = $points;
    }

    public function getMin(): TotalInterface {
        return new PointsTotal($this->points->getMin());
    }

    public function getMax(): TotalInterface {
        return new PointsTotal($this->points->getMax());
    }

    public function getValue(): TotalInterface {
        return new PointsTotal($this->points->getValue());
    }
}
