<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;

use Points\Core\Total\Shipping;
use Points\Core\Amount;

class QuoteShippingCurrency {
    /**
     * @var Shipping<int>
     */
    protected $shipping;

    /**
     * @param Shipping<int> $shipping
     */
    public function __construct(Shipping $shipping) {
        $this->shipping = $shipping;
    }

    public function getMin(): MageQL_Core_Model_Price_Abstract {
        $price = $this->shipping->getPrice();

        return new CurrencyTotal($this->shipping->getPoints() ? new Amount(0.0, $price->getValueIncludesTax(), 0.0) : $price);
    }

    public function getMax(): MageQL_Core_Model_Price_Abstract {
        return new CurrencyTotal($this->shipping->getPrice());
    }

    public function getValue(): MageQL_Core_Model_Price_Abstract {
        return new CurrencyTotal($this->shipping->getPrice());
    }
}
