<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;
use MageQL_Core_Model_Price_Abstract;

use Points\Core\Amount;
use Points\Core\Total\Shipping;

class QuoteSelectedShippingCurrency extends QuoteShippingCurrency {
    /**
     * @var Mage_Sales_Model_Quote
     */
    protected $quote;

    /**
     * @param Shipping<int> $shipping
     */
    public function __construct(Shipping $shipping, Mage_Sales_Model_Quote $quote) {
        parent::__construct($shipping);

        $this->quote = $quote;
    }

    public function getRemaining(): MageQL_Core_Model_Price_Abstract {
        $shipping = $this->quote->getShippingAddress();

        return new CurrencyTotal(new Amount(
            abs($shipping->getShippingAmount() +
            $shipping->getShippingHiddenTaxAmount() -
            $shipping->getShippingDiscountAmount() -
            $shipping->getPointsShippingTotal()),
            false,
            abs($shipping->getShippingTaxAmount() -
            $shipping->getPointsShippingTaxTotal())
        ));
    }
}
