<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;
use Mage_Sales_Model_Quote;

use Points\Core\Amount;
use Points\Core\Total\QuoteAddress;

class QuoteSelectedCurrency extends QuoteCurrency {
    /**
     * @var Mage_Sales_Model_Quote
     */
    protected $quote;

    public function __construct(
        QuoteAddress $total,
        QuotePoints $points,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($total, $points);

        $this->quote = $quote;
    }

    public function getRemaining(): MageQL_Core_Model_Price_Abstract {
        $tax = 0.0;

        foreach($this->quote->getAddressesCollection() as $addr) {
            $tax += (float)$addr->getTaxAmount();
        }

        return new CurrencyTotal(new Amount(
            (float)$this->quote->getGrandTotal(),
            true,
            $tax
        ));
    }
}
