<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\Total\Shipping as ShippingTotal;
use Points\Core\Total\QuoteAddress;

class QuoteSelected extends Quote {
    /**
     * @var ?QuoteSelectedPoints
     */
    private $points;

    public function getPoints(): QuotePoints {
        if( ! $this->points) {
            $this->points = new QuoteSelectedPoints($this->type, $this->total, $this->quote, $this->provider);
        }

        return $this->points;
    }

    public function getCurrency(): QuoteCurrency {
        return new QuoteSelectedCurrency($this->total, $this->getPoints(), $this->quote);
    }

    public function getShipping(): ?QuoteShipping {
        foreach($this->total->getTotals() as $total) {
            if($total instanceof ShippingTotal) {
                return new QuoteSelectedShipping($total, $this->quote);
            }
        }

        return null;
    }

    public function getDiscount(): ?QuoteDiscount {
        $discount = $this->total->getDiscountTotal();

        if($discount->getTotalInclTax() > 0) {
            return new QuoteSelectedDiscount($this->total, $this->getPoints(), $this->quote);
        }

        return null;
    }
}
