<?php

namespace Points\Core\Schema;

use Points_Core_Model_Limit_Total;

class QuoteRejectionReasonTotalLimit extends QuoteRejectionReason {
    /**
     * @var int
     */
    protected $remaining;

    /**
     * @var Points_Core_Model_Limit_Total
     */
    protected $limit;

    public function __construct(
        int $requested,
        Points_Core_Model_Limit_Total $limit,
        int $remaining
    ) {
        parent::__construct($requested, (bool)$limit->getIncludesTax());

        $this->remaining = $remaining;
        $this->limit = $limit;
    }

    public function getRemaining(): int {
        return $this->remaining;
    }

    public function getLimit(): int {
        return (int)$this->limit->getLimit();
    }

    public function getResetsAt(): string {
        return $this->limit->getNextResetDatetime();
    }
}
