<?php

namespace Points\Core\Schema;

class QuoteRejectionReasonOrderLimit extends QuoteRejectionReason {
    /**
     * @var int
     */
    protected $limit;

    public function __construct(
        int $requested,
        bool $includesTax,
        int $limit
    ) {
        parent::__construct($requested, $includesTax);

        $this->limit = $limit;
    }

    public function getLimit(): int {
        return (int)$this->limit;
    }
}
