<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote_Item;

use Points\Core\Total\Item;
use Points\Core\Amount;

class QuoteItemSelectedPoints extends QuoteItemPoints {
    /**
     * @var Mage_Sales_Model_Quote_Item
     */
    protected $item;

    /**
     * @param Item<int> $totals
     */
    public function __construct(Item $totals, Mage_Sales_Model_Quote_Item $item) {
        parent::__construct($totals);

        $this->item = $item;
    }

    public function getSelected(): TotalInterface {
        return new PointsTotal(new Amount(
            (int)$this->item->getPointsRowPoints(),
            false,
            (int)$this->item->getPointsRowTaxPoints()
        ));
    }
}
