<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Catalog_Model_Product_Price;
use Mage_Tax_Model_Config;
use MageQL\Context;

class QuoteItemSelectedCurrency extends QuoteItemCurrency {
    public function getRemaining(
        array $unusedArgs,
        Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        $includesVat = $ctx->getStore()->getConfig(Mage_Tax_Model_Config::CONFIG_XML_PATH_PRICE_INCLUDES_TAX);
        $rowTotal = $this->getRowTotal($ctx->getStore());
        $pointsTotal = $this->item->getPointsRowTotal() + ($includesVat ? $this->item->getPointsRowTaxTotal() : 0);

        return new MageQL_Catalog_Model_Product_Price(
            $this->item->getProduct(),
            $rowTotal - $pointsTotal
        );
    }
}
