<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\Total\QuoteAddress;

class QuoteDiscountPoints {
    /**
     * @var QuoteAddress
     */
    protected $total;
    /**
     * @var QuotePoints
     */
    protected $points;

    public function __construct(QuoteAddress $total, QuotePoints $points) {
        $this->total = $total;
        $this->points = $points;
    }

    public function getMin(): TotalInterface {
        $min = $this->points->getMin()->getTotalAndTax(true);
        $value = $this->points->getValue()->getTotalAndTax(true);
        $incRate = $value > 0 ? $min / $value : 0;

        return new PointsTotal($this->total->getPoints()->getDiscount()->multiply($incRate, 0));
    }

    public function getMax(): TotalInterface {
        $max = $this->points->getMax()->getTotalAndTax(true);
        $value = $this->points->getValue()->getTotalAndTax(true);
        $incRate = $value > 0 ? $max / $value : 0;

        return new PointsTotal($this->total->getPoints()->getDiscount()->multiply($incRate, 0));
    }

    public function getValue(): TotalInterface {
        return new PointsTotal($this->total->getPoints()->getDiscount());
    }
}
