<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;

use Points\Core\Amount;
use Points\Core\Total\QuoteAddress;

class QuoteDiscountCurrency {
    /**
     * @var QuoteAddress
     */
    protected $total;
    /**
     * @var QuotePoints
     */
    protected $points;

    public function __construct(QuoteAddress $total, QuotePoints $points) {
        $this->total = $total;
        $this->points = $points;
    }

    public function getMin(): MageQL_Core_Model_Price_Abstract {
        $included = $this->total->getIncluded()->getDiscountTotal();
        $excluded = $this->total->getExcluded()->getDiscountTotal();

        // TODO: Inc vat
        $pointsValue = $this->points->getValue()->getTotalAndTax(true);
        $pointsMin = $this->points->getMin()->getTotalAndTax(true);
        $factor = $pointsValue > 0 ? $pointsMin / $pointsValue : 0.0;

        return new CurrencyTotal($excluded->add($included->multiply($factor, 2)));
    }

    public function getMax(): MageQL_Core_Model_Price_Abstract {
        $included = $this->total->getIncluded()->getDiscountTotal();
        $excluded = $this->total->getExcluded()->getDiscountTotal();

        // TODO: Inc vat
        $pointsValue = $this->points->getValue()->getTotalAndTax(true);
        $pointsMax = $this->points->getMax()->getTotalAndTax(true);
        $factor = $pointsValue > 0 ? $pointsMax / $pointsValue : 0.0;

        return new CurrencyTotal($excluded->add($included->multiply($factor, 2)));
    }

    public function getValue(): MageQL_Core_Model_Price_Abstract {
        return new CurrencyTotal($this->total->getDiscountTotal());
    }
}
