<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Catalog_Model_Product_Price;
use Mage_Catalog_Model_Product;
use Points_Core_Model_Product_Index;
use Points_Core_Model_Product_Price;

class ProductCurrency {
    /**
     * @var Points_Core_Model_Product_Price|Points_Core_Model_Product_Index
     */
    protected $points;

    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    /**
     * @param Points_Core_Model_Product_Price|Points_Core_Model_Product_Index $points
     */
    public function __construct(
        Mage_Catalog_Model_Product $product,
        $points
    ) {
        $this->points = $points;
        $this->product = $product;
    }

    public function getMin(): MageQL_Catalog_Model_Product_Price {
        $percent = $this->points->getPrice() > 0 && $this->points->getMaxPrice() !== null ?
            min(max($this->points->getPrice() - (int)$this->points->getMaxPrice(), 0) / $this->points->getPrice(), 1) :
            0;

        return new MageQL_Catalog_Model_Product_Price(
            $this->product,
            $this->product->getFinalPrice() * $percent
        );
    }

    public function getMax(): MageQL_Catalog_Model_Product_Price {
        $percent = $this->points->getPrice() > 0 ?
            1 - max($this->points->getMinPriceInRange() / $this->points->getPrice(), 0) :
            1;

        return new MageQL_Catalog_Model_Product_Price(
            $this->product,
            $this->product->getFinalPrice() * $percent
        );
    }

    public function getValue(): MageQL_Catalog_Model_Product_Price {
        return new MageQL_Catalog_Model_Product_Price(
            $this->product,
            $this->product->getFinalPrice()
        );
    }
}
