<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage;
use Mage_Customer_Model_Customer;
use MageQL\Context;
use Points\Core\ProviderInterface;

class CustomerPointsBalance {
    /**
     * @var string
     */
    protected $type;

    /**
     * @var ProviderInterface
     */
    protected $provider;

    /**
     * @var Mage_Customer_Model_Customer
     */
    protected $customer;

    public function __construct(
        string $type,
        ProviderInterface $provider,
        Mage_Customer_Model_Customer $customer
    ) {
        $this->type = $type;
        $this->provider = $provider;
        $this->customer = $customer;
    }

    public function getId(): string {
        return $this->type;
    }

    public function getLabel(array $unusedArgs, Context $ctx): string {
        return $this->provider->getLabel($ctx->getStore());
    }

    public function getPoints(array $unusedArgs, Context $ctx): int {
        return $this->provider->getCustomerPointsBalance($ctx->getStore(), $this->customer);
    }

    public function getPointsIncludeVat(array $unusedArgs, Context $ctx): bool {
        return $this->provider->getCustomerPointsBalanceIncludesTax($ctx->getStore(), $this->customer);
    }

    public function getRedemptionAllowed(array $unusedArgs, Context $ctx): bool {
        return $this->provider->getCustomerRedemptionAllowed($ctx->getStore(), $this->customer);
    }

    public function getPointsSpent(array $unusedArgs, Context $ctx): int {
        $model = Mage::getResourceModel("points_core/limit_total");
        $includesTax = $this->provider->getCustomerPointsBalanceIncludesTax($ctx->getStore(), $this->customer);

        return $model->getTotalSpent($this->type, $this->customer, $includesTax);
    }

    public function getSpendingLimit(
        array $unusedArgs,
        Context $ctx
    ): ?PointsSpendingLimit {
        $model = Mage::getResourceModel("points_core/limit_total");

        $limits = $model->getMatchingLimits($ctx->getStore(), $this->customer->getGroupId(), [$this->type]);

        if(empty($limits[$this->type]) || $limits[$this->type]->getLimit() === null) {
            return null;
        }

        return new PointsSpendingLimit($this->customer, $limits[$this->type]);
    }
}
