<?php

declare(strict_types=1);

use MageQL\ClientException;
use GraphQL\Error\ClientAware;

/**
 * Exception triggered when a quote with required point payment does not have one set.
 */
class Points_Core_PointPaymentRequiredException
    extends ClientException
    implements ClientAware {
    public function __construct() {
        parent::__construct("points_payment_required");
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "points_core";
    }

    public function getExtensions(): array {
        return [
            "code" => "points_payment_required",
        ];
    }
}
