<?php

declare(strict_types=1);

class Points_Core_Model_Sales_Total_Creditmemo_Points extends Mage_Sales_Model_Order_Creditmemo_Total_Abstract
{
    public function collect(Mage_Sales_Model_Order_Creditmemo $creditmemo) {
        $order = $creditmemo->getOrder();

        // Refund the difference between already refunded and invoiced
        $points = $order->getPointsPointsInvoiced() - $order->getPointsPointsRefunded();
        $taxPoints = $order->getPointsTaxPointsInvoiced() - $order->getPointsTaxPointsRefunded();
        // Tax is already deducted from the grand total by modifying tax
        $amount = abs($order->getPointsAmountInvoiced()) - $order->getPointsAmountRefunded();
        $baseAmount = abs($order->getBasePointsAmountInvoiced()) - $order->getBasePointsAmountRefunded();
        $taxAmount = $order->getPointsTaxAmountInvoiced() - $order->getPointsTaxAmountRefunded();
        $baseTaxAmount = $order->getBasePointsTaxAmountInvoiced() - $order->getBasePointsTaxAmountRefunded();

        $creditmemo->setGrandTotal($creditmemo->getGrandTotal() + $amount);
        $creditmemo->setBaseGrandTotal($creditmemo->getBaseGrandTotal() + $baseAmount);

        // Make sure we also add the specific amounts
        $creditmemo->setPointsAmount($amount);
        $creditmemo->setBasePointsAmount($baseAmount);

        // Rate is number of points per unit of currency
        $creditmemo->setPointsType($order->getPointsType());
        $creditmemo->setPointsPoints($points);
        $creditmemo->setPointsTaxPoints($taxPoints);
        $creditmemo->setPointsAmount($amount);
        $creditmemo->setBasePointsAmount($baseAmount);
        $creditmemo->setPointsTaxAmount($taxAmount);
        $creditmemo->setBasePointsTaxAmount($baseTaxAmount);

        return $this;
    }
}
