<?php

declare(strict_types=1);

class Points_Core_Model_Resource_Product_Index_Collection
    extends Mage_Core_Model_Resource_Db_Collection_Abstract {

    protected function _construct(): void {
        $this->_init("points_core/product_index");
    }

    public function filterByStore(Mage_Core_Model_Store $store): void {
        $this->getSelect()->where("website_id = ?", $store->getWebsiteId());
    }

    /**
     * @param Array<int> $productIds
     */
    public function filterByProductIds(array $productIds): void {
        $this->getSelect()->where("product_id IN (?)", $productIds);
    }

    /**
     * @param Array<string> $types
     */
    public function filterByTypes(array $types): void {
        $this->getSelect()->where("type IN (?)", $types);
    }

    /**
     * @param int $customerGroupId
     */
    public function filterByCustomerGroupId($customerGroupId): void {
        $this->getSelect()->where("customer_group_id = ?", $customerGroupId);
    }
}
