<?php

declare(strict_types=1);

class Points_Core_Model_Resource_Limit_Total_Collection
    extends Mage_Core_Model_Resource_Db_Collection_Abstract {

    protected function _construct(): void {
        $this->_init("points_core/limit_total");
    }

    public function filterByStore(Mage_Core_Model_Store $store): void {
        $this->getSelect()->where("store_id = ?", $store->getId());
    }

    public function filterByNotLoggedInCustomerGroup(): void {
        $this->getSelect()->where("customer_group_id = ?", Mage_Customer_Model_Group::NOT_LOGGED_IN_ID);
    }

    public function filterByCustomerGroups(): void {
        $this->getSelect()->where("customer_group_id <> ?", Mage_Customer_Model_Group::NOT_LOGGED_IN_ID);
    }
}
