<?php

declare(strict_types=1);

use MageQL\Context;
use Points\Core\Schema\ProductCurrency;
use Points\Core\Schema\ProductPoints;

class Points_Core_Model_Product_Price_Item {
    /**
     * @var Points_Core_Model_Product_Price|Points_Core_Model_Product_Index
     */
    protected $points;

    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    /**
     * @param Points_Core_Model_Product_Price|Points_Core_Model_Product_Index $points
     */
    public function __construct(
        Mage_Catalog_Model_Product $product,
        $points
    ) {
        $this->product = $product;
        $this->points = $points;
    }

    public function getProduct(): Mage_Catalog_Model_Product {
        return $this->product;
    }

    public function getId(): string {
        return $this->points->getType();
    }

    public function getLabel(array $_args, Context $ctx): string {
        $provider = Mage::helper("points_core")->getTypeProvider($this->points->getType());

        return $provider ? $provider->getLabel($ctx->getStore()) : "";
    }

    public function getCurrencyRequired(): bool {
        return ($this->points->getMaxPrice() ?? $this->points->getPrice()) < $this->points->getPrice();
    }

    public function getPoints(): ProductPoints {
        return new ProductPoints($this->product, $this->points);
    }

    public function getCurrency(): ProductCurrency {
        return new ProductCurrency($this->product, $this->points);
    }
}
