<?php

abstract class Points_Core_Block_Points_Config_Edit_Tab_Abstract
    extends Mage_Adminhtml_Block_Widget_Form
    implements Mage_Adminhtml_Block_Widget_Tab_Interface
{
    public function canDisplayUseDefault(): bool
    {
        return $this->getRequest()->getParam('store') > 0;
    }

    public function canShowTab(): bool
    {
        return true;
    }

    public function isHidden(): bool
    {
        return false;
    }

    public function getElemName(array $item, array $keys): string
    {
        return sprintf(
            'points[%s][%s][%s]%s',
            $item['store_id'],
            $item['customer_group_id'],
            $item['type'],
            implode('', array_map(function ($key): string {
                return "[{$key}]";
            }, $keys))
        );
    }

    public function getValue(array $item, array $keys): string
    {
        $key = array_shift($keys);
        switch (gettype($item[$key])) {
            case 'array':
                return $this->getValue($item[$key], $keys);
            default:
                return (string)$item[$key];
        }
    }

    public function getInputHidden(array $item, array $keys): string
    {
        return sprintf(
            '<input type="hidden" name="%1$s" value="%2$s">',
            $this->getElemName($item, $keys),
            $this->getValue($item, $keys)
        );
    }

    public function getInputText(array $item, array $keys): string
    {
        return sprintf(
            '<input type="text" name="%1$s" value="%2$s" %3$s class="input-text validate-zero-or-greater">',
            $this->getElemName($item, $keys),
            $this->getValue($item, $keys),
            !empty($this->getValue($item, [$keys[0], 'use_default'])) ? 'disabled="disabled"' : '',
        );
    }

    public function getInputCheckbox(array $item, array $keys): string
    {
        return sprintf(
            '<input type="hidden" name="%1$s" value="0"><input type="checkbox" %2$s name="%1$s" value="1" %3$s>',
            $this->getElemName($item, $keys),
            $this->getValue($item, $keys) ? 'checked="checked"' : '',
            !empty($this->getValue($item, [$keys[0], 'use_default'])) ? 'disabled="disabled"' : '',
        );
    }

    public function getUseDefaultCheckbox(array $item, array $keys, string $onclick): string
    {
        return sprintf(
            '<input type="hidden" name="%1$s" value="0"><input type="checkbox" %2$s name="%1$s" value="1" %3$s>',
            $this->getElemName($item, $keys),
            $this->getValue($item, $keys) ? 'checked="checked"' : '',
            "onclick=\"{$onclick}\""
        );
    }

    public function getInputTimeInterval(array $item, array $keys): string
    {
        $options = [];
        foreach ([
            Points_Core_Model_Limit_Total::INTERVAL_WEEK,
            Points_Core_Model_Limit_Total::INTERVAL_MONTH,
            Points_Core_Model_Limit_Total::INTERVAL_QUARTER,
            Points_Core_Model_Limit_Total::INTERVAL_YEAR,
        ] as $interval) {
            $options[] = sprintf(
                '<option value="%1$s" %2$s >%3$s</option>',
                $interval,
                $this->getValue($item, $keys) == $interval ? 'selected="selected"' : '',
                ucfirst(strtolower($interval))
            );
        }
        return sprintf(
            '<select name="%1$s" %3$s>%2$s</select>',
            $this->getElemName($item, $keys),
            implode('', $options),
            !empty($this->getValue($item, [$keys[0], 'use_default'])) ? 'disabled="disabled"' : '',
        );
    }
}
