<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$quoteColumns = [
    "points_shipping_points_value" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => true,
        "comment" => "Value of the shipping for quote/order in points excluding tax",
    ],
    "points_shipping_tax_points_value" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => true,
        "comment" => "Tax value of the shipping for quote/order in points",
    ],
];

foreach($quoteColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/quote"), $col, $spec);
    $conn->addColumn($this->getTable("sales/quote_address"), $col, $spec);
    $conn->addColumn($this->getTable("sales/order"), $col, $spec);
}

$installer->endSetup();
