<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$productPriceTable = $conn->newTable($installer->getTable("points_core/product_price"));

$productPriceTable->addColumn("entity_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "identity" => true,
    "unsigned" => true,
    "nullable" => false,
    "primary" => true,
], "Point price row entity id");
$productPriceTable->addColumn("product_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "unsigned" => true,
    "nullable" => false,
], "Product entity id");
$productPriceTable->addColumn("store_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
], "Store Id");
$productPriceTable->addColumn("customer_group_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
], "Store Id");
$productPriceTable->addColumn("type", Varien_Db_Ddl_Table::TYPE_TEXT, 64, [
    "nullable" => false,
], "Point type code");
$productPriceTable->addColumn("price", Varien_Db_Ddl_Table::TYPE_INTEGER, 11, [
    "nullable" => false,
]);
$productPriceTable->addColumn("min_price", Varien_Db_Ddl_Table::TYPE_INTEGER, 11, [
    "nullable" => false,
    "default" => 0,
]);
$productPriceTable->addColumn("max_price", Varien_Db_Ddl_Table::TYPE_INTEGER, 11, [
    "nullable" => true,
]);
$productPriceTable->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
], "Created at");
$productPriceTable->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
], "Updated at");


$productPriceTable->addIndex(
    $installer->getIdxName("points_core/product_price", ["store_id", "customer_group_id", "product_id", "type"], Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE),
    ["store_id", "customer_group_id", "product_id", "type"],
    ["type" => Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE]
);

$productPriceTable->addForeignKey(
    $installer->getFkName("points_core/product_price", "product_id", "catalog/product", "entity_id"),
    "product_id",
    $installer->getTable("catalog/product"),
    "entity_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);
$productPriceTable->addForeignKey(
    $installer->getFkName("points_core/product_price", "store_id", "core/store", "store_id"),
    "store_id",
    $installer->getTable("core/store"),
    "store_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);
$productPriceTable->addForeignKey(
    $installer->getFkName("points_core/product_price", "customer_group_id", "customer/customer_group", "customer_group_id"),
    "customer_group_id",
    $installer->getTable("customer/customer_group"),
    "customer_group_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);

$productPriceTable->setOption("type", "InnoDB");
$productPriceTable->setOption("charset", "utf8");

$conn->createTable($productPriceTable);

$tables = [$this->getTable("sales/quote"), $this->getTable("sales/quote_address")];
$columns = [
    "points_type" => [
        "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length" => 64,
        "nullable" => true,
        "comment" => "The points currency type code used, if any",
    ],
    "points_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points to spend on this quote excluding tax",
    ],
    "points_tax_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points to spend on this quote for tax",
    ],
    "base_points_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover, excluding tax value",
    ],
    "base_points_tax_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover of the tax value",
    ],
    "points_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
    "points_tax_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
];

foreach($tables as $table) {
    foreach($columns as $col => $spec) {
        $conn->addColumn($table, $col, $spec);
    }
}

$itemColumns = [
    "points_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points excluding tax",
    ],
    "points_tax_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points for tax, always proportional",
    ],
    "points_base_row_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover, excluding tax value",
    ],
    "points_base_row_tax" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover of the tax value",
    ],
    "points_row_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
    "points_row_tax" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
];

foreach($itemColumns as $col => $spec) {
    $conn->addColumn($installer->getTable("sales/quote_item"), $col, $spec);
}

$installer->endSetup();
