<?php

/**
 * @psalm-scope-this Mage_Catalog_Model_Resource_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$installer->addAttribute("catalog_product", "points_payment_required", [
    "group"            => "General",
    "label"            => "Require Point Payment",
    "type"             => "int",
    "input"            => "boolean",
    "required"         => false,
    "visible_on_front" => false,
    "used_in_product_listing" => false,
    "filterable"       => false,
    "searchable"       => false,
    "comparable"       => false,
    "user_defined"     => false,
    "default"          => 0,
    "is_configurable"  => false,
    // Hide in admin
    "visible"          => false,
    "global"           => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    "note"             => "If the product requires points payment to allow purchase",
    "position"         => 40,
]);

$installer->endSetup();
