<?php

declare(strict_types=1);

class Points_Core_Adminhtml_Points_ConfigController extends Mage_Adminhtml_Controller_Action
{
    public function indexAction(): void
    {
        $this->loadLayout();
        $this->renderLayout();
    }

    public function saveAction(): void
    {
        $this->helper = Mage::helper('points_core');
        $session_store_id = Mage_Catalog_Model_Abstract::DEFAULT_STORE_ID;

        if ($request = $this->getRequest()->getPost()) {
            try {
                $session_store_id = $request['store'];

                foreach ($request['points'] as $store => $customer_group_ids) {
                    $store_id = intval($store);

                    foreach ($customer_group_ids as $customer_group_id => $types) {
                        $customer_group_id = intval($customer_group_id);

                        foreach ($types as $type => $settings) {
                            $this->updateOrderLimit($store_id, $customer_group_id, $type, $settings);
                            $this->updateTotalLimit($store_id, $customer_group_id, $type, $settings);
                        }
                    }
                }

                Mage::getSingleton('adminhtml/session')->addSuccess($this->helper->__('Successfully saved.'));

            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($this->helper->__('Invalid data provided.'));
                Mage::log($e->getMessage(), Zend_Log::WARN);
            }
        }
        $this->_redirect('*/*/index', ['store'=> $session_store_id]);
    }

    private function updateOrderLimit(
        int $store_id,
        int $customer_group_id,
        string $type,
        array $settings): void
    {
        // Create/update order limit entity
        $model = Mage::getModel('points_core/limit_order');
        if ($settings['order']['id'] !== '') {
            $model->load($settings['order']['id']);
            if (!empty($settings['order']['use_default'])) {
                $model->delete();
                return;
            }
        } else {
            if (!empty($settings['order']['use_default'])) {
                return;
            }
            $model->setData([
                'store_id' => $store_id,
                'customer_group_id' => $customer_group_id,
                'type' => $type,
            ]);
        }
        $model->addData([
            'min_percent' => $this->format('percent', $settings['order']['min_percent']),
            'max_percent' => $this->format('percent/null', $settings['order']['max_percent']),
            'min_value' => $this->format('int', $settings['order']['min_value']),
            'max_value' => $this->format('int/null', $settings['order']['max_value']),
            'includes_tax' => $settings['order']['includes_tax'] ?? 0,
        ]);
        $model->save();
    }

    private function updateTotalLimit(
        int $store_id,
        int $customer_group_id,
        string $type,
        array $settings): void
    {
        // Create/update total limit entity
        $model = Mage::getModel('points_core/limit_total');
        if ($settings['total']['id'] !== '') {
            $model->load($settings['total']['id']);
            if (!empty($settings['total']['use_default'])) {
                $model->delete();
                return;
            }
        } else {
            if (!empty($settings['total']['use_default'])) {
                return;
            }
            $model->setData([
                'store_id' => $store_id,
                'customer_group_id' => $customer_group_id,
                'type' => $type,
            ]);
        }
        $model->addData([
            'time_interval' => $settings['total']['time_interval'],
            'limit' => $this->format('int/null', $settings['total']['limit']),
            'includes_tax' => $settings['total']['includes_tax'] ?? 0,
        ]);
        $model->save();
    }

    private function format($type, $value)
    {
        switch ($type) {
            case 'percent':
                return max(0, min(100, $value));
            case 'percent/null':
                return $value === '' ? null : max(0, min(100, $value));
            case 'int':
                return max(0, $value);
            case 'int/null':
                return $value === '' ? null : max(0, $value);
        }
        return $value;
    }
}
