<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Core_Model_Store;
use MageQL_Core_Model_Price_Abstract;

// TODO: Rename to CurrencyTotal, or we can use Amount and a different price type
class QuoteCurrencyTotal extends MageQL_Core_Model_Price_Abstract {
    /**
     * @var float
     */
    protected $value;

    /**
     * @var float
     */
    protected $tax;

    /**
     * @var bool
     */
    protected $valueIncludesTax;

    public function __construct(float $value, bool $valueIncludesTax, float $tax) {
        $this->value = $value;
        $this->valueIncludesTax = $valueIncludesTax;
        $this->tax = $tax;
    }

    public function getIncVat(Mage_Core_Model_Store $store): float {
        return $store->roundPrice($this->valueIncludesTax ? $this->value : $this->value + $this->tax);
    }

    public function getExVat(Mage_Core_Model_Store $store): float {
        return $store->roundPrice($this->valueIncludesTax ? $this->value - $this->tax : $this->value);
    }

    public function getVat(Mage_Core_Model_Store $store): float {
        return $store->roundPrice($this->tax);
    }
}
