# Point Core Module

Core module for point-based checkout in Magento.

## Columns

Naming:

* `_value`: Value of the item/quote/order/shipping in points.
* `_points`: Selected amount of points.
* `_total`: Currency total corresponding to the selected amount of points.
* `_amount`: Currency total corresponding to the selected amount of points summed with other amounts.

### Quote & Order

* `points_type`: Point currency type used, if any.

### Quote & Quote Address & Order

* `points_value`: Value of the quote in points excluding tax
* `points_tax_value`: Value of the quote in points excluding tax
* `points_points`: Points spent on order excluding tax
* `points_tax_points`: Points spent on order in terms of tax
* `points_amount`: Amount of currency the points cover, excluding tax
* `points_tax_amount`: Amount of currency the points cover in terms of tax
* `base_points_amount`: Amount of base currency the points cover, excluding tax
* `base_points_tax_amount`: Amount of base currency the points cover in terms of tax

Discount related columns:

* `points_discount_points`: Points discounted by any discount, excluding tax
* `points_discount_tax_points`: Points discounted by any discount in tax
* `points_discount_value`: Value of discount in points, excluding tax, for all products with point price
* `points_discount_tax_value`: Value of discount tax in points
* `points_discount_total`: Amount of currency the points cover of discount, excluding tax
* `points_discount_tax_total`: Amount of currency the points cover of tax in discount
* `base_points_discount_total`: Amount of base currency the points cover of discount, excluding tax
* `base_points_discount_tax_total`: Amount of base currency the points cover of tax in discount

How the payment was split between points and currency:

* `points_amount_included`: Amount of base currency included in the points calculation, excluding tax
* `points_tax_amount_included`: Amount of base currency included in the points calculation in terms of tax
* `points_amount_excluded`: Amount of base currency excluded in the points calculation, excluding tax
* `points_tax_amount_excluded`: Amount of base currency excluded in the points calculation in terms of tax

How shipping is paid:

* `points_shipping_value`: Value of the shipping in points, excluding tax
* `points_shipping_tax_value`: Value of the shipping tax in points
* `points_shipping_points`: Number of points spent on shipping, excluding tax
* `points_shipping_tax_points`: Number of points spent on shipping in tax
* `points_shipping_total`: Amount of currency the points cover, exlcuding tax
* `points_shipping_tax_total`: Amount of currency the points cover in tax
* `base_points_shipping_total`: Amount of currency the points cover, exlcuding tax
* `base_points_shipping_tax_total`: Amount of currency the points cover in tax

### Quote Item & Order item

* `points_row_value`: Row value in points excluding tax
* `points_row_tax_value`: Row value in points for tax
* `points_row_points`: Number of points spent on this row, excluding tax
* `points_row_tax_points`: Number of points spent on this row, excluding tax
* `points_row_total`: Amount of currency the points cover, excluding tax
* `points_row_tax_total`: Amount of currency the points cover in tax
* `base_points_row_total`: Amount of base currency the points cover, excluding tax
* `base_points_row_tax_total`: Amount of base currency the points cover in tax

### Order

* `points_points_invoiced`: Amount of points invoiced, excluding tax
* `points_tax_points_invoiced`: Amount of points invoiced for tax
* `base_points_amount_invoiced`: Amount of base currency invoiced as points, excluding tax
* `base_points_tax_amount_invoiced`: Amount of base currency tax invoiced as points
* `points_amount_invoiced`: Amount of currency invoiced as points, excluding tax
* `points_tax_amount_invoiced`: Amount of currency tax invoiced as points

Refunds:

* `points_points_refunded`: Amount of points refunded, excluding tax
* `points_tax_points_refunded`: Amount of points refunded for tax
* `base_points_amount_refunded`: Amount of base currency refunded as points, excluding tax
* `base_points_tax_amount_refunded`: Amount of base currency tax refunded as points
* `points_amount_refunded`: Amount of currency refunded as points, excluding tax
* `points_tax_amount_refunded`: Amount of currency tax refunded as points

## Range

```javascript
# Minimum number of points possible to spend
points.min
# Maximum number of points possible to spend on the item
points.max
# Value of the item in points
points.value

# Minimum amount of currency to spend
currency.min = excluded + included * (1 - points.max / points.value)
# Maximum amount of currency to spend
currency.max = excluded + included * (points.min / points.value)
# Total value of the quote/item
currency.value = included + excluded OR row_total OR grand_total + abs(points.amount)

# Currently selected points
points.current
# Maximum number of points the customer can spend
points.maxAvailable = min(points.max, customer.availableBalance)
# Currently remaining currency when points have been selected
currency.remaining = excluded + ???
```
