<?php

declare(strict_types=1);

/**
 * Amounts never include tax.
 *
 * Points to spend on quote:
 *
 * @method ?string getPointsType()
 * @method void setPointsType(?string $type)
 * @method int getPointsPoints()
 * @method void setPointsPoints(int $points)
 * @method int getPointsTaxPoints()
 * @method void setPointsTaxPoints(int $points)
 *
 * Amount of currency excluding tax corresponding to the points spent:
 *
 * @method float getBasePointsAmount()
 * @method void setBasePointsAmount(float $amount)
 * @method float getPointsAmount()
 * @method void setPointsAmount(float $amount)
 *
 * Amount of currency for tax corresponding to the points spent, is not included
 * in tax total or grand total (add to grand total along with positive value of
 * points amount to get quote value in currency):
 *
 * @method float getBasePointsTaxAmount()
 * @method void setBasePointsTaxAmount(float $amount)
 * @method float getPointsTaxAmount()
 * @method void setPointsTaxAmount(float $amount)
 *
 * Value in points for this quote including shipping (only counts products which
 * have a point price):
 *
 * @method int getPointsValue()
 * @method void setPointsValue(int $value)
 * @method int getPointsTaxValue()
 * @method void setPointsTaxValue(int $value)
 *
 * Shipping value in points if shipping can be paid using points:
 *
 * @method ?int getPointsShippingValue()
 * @method void setPointsShippingValue(?int $value)
 * @method ?int getPointsShippingTaxValue()
 * @method void setPointsShippingTaxValue(?int $value)
 *
 * Actual amounts spent on shipping:
 *
 * @method int getPointsShippingPoints()
 * @method void setPointsShippingPoints(int $points)
 * @method int getPointsShippingTaxPoints()
 * @method void setPointsShippingTaxPoints(int $points)
 * @method float getPointsShippingTotal()
 * @method void setPointsShippingTotal(float $amount)
 * @method float getPointsShippingTaxTotal()
 * @method void setPointsShippingTaxTotal(float $amount)
 * @method float getBasePointsShippingTotal()
 * @method void setBasePointsShippingTotal(float $amount)
 * @method float getBasePointsShippingTaxTotal()
 * @method void setBasePointsShippingTaxTotal(float $amount)
 *
 * Value of discount in points, as well as amount of points discounted and
 * their value in currency:
 *
 * @method int getPointsDiscountValue()
 * @method void setPointsDiscountValue(int $value)
 * @method int getPointsDiscountTaxValue()
 * @method void setPointsDiscountTaxValue(int $value)
 * @method int getPointsDiscountPoints()
 * @method void setPointsDiscountPoints(int $points)
 * @method int getPointsDiscountTaxPoints()
 * @method void setPointsDiscountTaxPoints(int $points)
 * @method float getPointsDiscountTotal()
 * @method void setPointsDiscountTotal(float $amount)
 * @method float getPointsDiscountTaxTotal()
 * @method void setPointsDiscountTaxTotal(float $amount)
 * @method float getBasePointsDiscountTotal()
 * @method void setBasePointsDiscountTotal(float $amount)
 * @method float getBasePointsDiscountTaxTotal()
 * @method void setBasePointsDiscountTaxTotal(float $amount)
 *
 * Amount of the currency value of this quote which is included in the point
 * calculation:
 *
 * @method float getPointsAmountIncluded()
 * @method void setPointsAmountIncluded(float $amount)
 * @method float getPointsTaxAmountIncluded()
 * @method void setPointsTaxAmountIncluded(float $amount)
 *
 * Amount of the currency value of this quote which is EXCLUDED in the point
 * calculation:
 *
 * @method float getPointsAmountExcluded()
 * @method void setPointsAmountExcluded(float $amount)
 * @method float getPointsTaxAmountExcluded()
 * @method void setPointsTaxAmountExcluded(float $amount)
 *
 * Non-persistent:
 *
 * @method void setPointsWanted(int $points)
 * @method ?int getPointsWanted()
 * @method bool hasPointsWanted()
 * @method void unsPointsWanted()
 * @method void setPointsWantedIncludesTax(bool $includesTax)
 * @method ?bool getPointsWantedIncludesTax()
 * @method bool hasPointsWantedIncludesTax()
 * @method void unsPointsWantedIncludesTax()
 * @method ?bool getBypassPointRequirement()
 * @method void setBypassPointRequirement(?bool $value)
 */
class Mage_Sales_Model_Quote {
}
