<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;
use Mage_Tax_Model_Config;
use MageQL\Context;
use Points\Core\Total\QuoteAddress;

class QuoteCurrency {
    /**
     * @var QuoteAddress
     */
    protected $total;
    /**
     * @var QuotePoints
     */
    protected $points;

    public function __construct(QuoteAddress $total, QuotePoints $points) {
        $this->total = $total;
        $this->points = $points;
    }

    public function getMin(
        array $unusedArgs,
        Context $ctx
    ): MageQL_Core_Model_Price_Abstract {
        $value = $this->points->getValue();
        $max = $this->points->getMax();
        $excluded = $this->total->getExcluded()->getTotal();
        $included = $this->total->getIncluded()->getTotal();
        $incVat = (bool)$ctx->getConfig(Mage_Tax_Model_Config::CONFIG_XML_PATH_PRICE_INCLUDES_TAX);

        $valueTotal = $value->getTotalAndTax($incVat);
        $maxTotal = $max->getTotalAndTax($incVat);
        $rate = $valueTotal > 0 ? max(1 - $maxTotal / $valueTotal, 0) : 0;

        $currencyMin = $excluded->add($included->multiply($rate, 2));

        return new CurrencyTotal($currencyMin);
    }

    public function getMax(
        array $unusedArgs,
        Context $ctx
    ): MageQL_Core_Model_Price_Abstract {
        $value = $this->points->getValue();
        $min = $this->points->getMin();
        $excluded = $this->total->getExcluded()->getTotal();
        $included = $this->total->getIncluded()->getTotal();
        $incVat = (bool)$ctx->getConfig(Mage_Tax_Model_Config::CONFIG_XML_PATH_PRICE_INCLUDES_TAX);

        $valueTotal = $value->getTotalAndTax($incVat);
        $minTotal = $min->getTotalAndTax($incVat);
        $rate = $valueTotal > 0 ? (1 - max($minTotal / $valueTotal, 0)) : 0;

        $currencyMin = $excluded->add($included->multiply($rate, 2));

        return new CurrencyTotal($currencyMin);
    }

    public function getValue(
        array $unusedArgs,
        Context $ctx
    ): MageQL_Core_Model_Price_Abstract {
        return new CurrencyTotal($this->total->getTotal());
    }
}
