<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points_Core_Model_Limit_Order;

class PointsTypeOrderLimits {
    /**
     * @var ?Points_Core_Model_Limit_Order
     */
    protected $limits;

    public function __construct(?Points_Core_Model_Limit_Order $limits) {
        $this->limits = $limits;
    }

    public function getMinValue(): int {
        return $this->limits ? max(0, (int)$this->limits->getMinValue()) : 0;
    }

    public function getMinPercent(): float {
        return $this->limits ? min(100, max(0, (float)$this->limits->getMinPercent())) : 0.0;
    }

    public function getMaxValue(): ?int {
        return $this->limits ? max(0, (int)$this->limits->getMaxValue()) : null;
    }

    public function getMaxPercent(): float {
        return $this->limits ? min(100, max(0, (float)($this->limits->getMaxPercent() ?? 100))) : 100.0;
    }

    public function getIncVat(): bool {
        return $this->limits ? (bool)$this->limits->getIncludesTax() : true;
    }
}
