<?php

declare(strict_types=1);

class Points_Core_Model_Sales_Total_Invoice_Points extends Mage_Sales_Model_Order_Invoice_Total_Abstract
{
    public function collect(Mage_Sales_Model_Order_Invoice $invoice)
    {
        $order = $invoice->getOrder();

        // Invoice the difference between already invoiced and total
        $points = $order->getPointsPoints() - $order->getPointsPointsInvoiced();
        $taxPoints = $order->getPointsTaxPoints() - $order->getPointsTaxPointsInvoiced();
        // Tax is already deducted from the grand total by modifying tax
        $amount = abs($order->getPointsAmount()) - $order->getPointsAmountInvoiced();
        $baseAmount = abs($order->getBasePointsAmount()) - $order->getBasePointsAmountInvoiced();
        $taxAmount = $order->getPointsTaxAmount() - $order->getPointsTaxAmountInvoiced();
        $baseTaxAmount = $order->getBasePointsTaxAmount() - $order->getBasePointsTaxAmountInvoiced();

        $invoice->setGrandTotal($invoice->getGrandTotal() - $amount);
        $invoice->setBaseGrandTotal($invoice->getBaseGrandTotal() - $baseAmount);

        // Make sure we also add the specific amounts
        $invoice->setPointsType($order->getPointsType());
        $invoice->setPointsPoints($points);
        $invoice->setPointsTaxPoints($taxPoints);
        $invoice->setPointsAmount($amount);
        $invoice->setBasePointsAmount($baseAmount);
        $invoice->setPointsTaxAmount($taxAmount);
        $invoice->setBasePointsTaxAmount($baseTaxAmount);

        return $this;
    }
}
