<?php

declare(strict_types=1);

namespace Points\Core;

use function Points\Core\calculateRoundingSpread;

use Mage;

use Crossroads\Magento\Test\Integration\MagentoManager;
use PHPUnit\Framework\TestCase;

class AmountsTest extends TestCase {
    public function setUp(): void {
        MagentoManager::reset();
        MagentoManager::init();
    }

    public function testEmpty(): void {
        $calculated = calculateRoundingSpread([]);

        $this->assertEquals([], $calculated);
    }

    public function testSingles(): void {
        $this->assertEquals([ "val" => 1 ], calculateRoundingSpread([ "val" => 0.9]));
        $this->assertEquals([ "val" => 1 ], calculateRoundingSpread([ "val" => 0.1]));
        $this->assertEquals([ "val" => 1 ], calculateRoundingSpread([ "val" => 0.4]));
        $this->assertEquals([ "val" => 1 ], calculateRoundingSpread([ "val" => 0.5]));
    }

    /*
    public function testOrder(): void {
        $initial = [
            "idx_0" => 266.4,
            "idx_1" => 399.8,
        ];

        $calculated = calculateRoundingSpread($initial);

        $this->assertSame([
            "idx_0" => 267,
            "idx_1" => 400,
        ], $calculated);
    }
     */

    public function testOne(): void {
        $total = 999;
        $calculated = calculateRoundingSpread([
            "amount" => 799.2,
            "tax" => 199.8,
        ]);

        $this->assertEquals([
            "amount" => 799,
            "tax" => 200,
        ], $calculated);
        $this->assertEquals($total, array_sum($calculated));
    }

    public function testNines(): void {
        $calculated = calculateRoundingSpread([
            "idx_0" => 3330.0,
            "idx_1" => 7494.999999999999,
        ]);

        $this->assertSame([
            "idx_0" => 3330,
            "idx_1" => 7495,
        ], $calculated);
    }

    public function testMultiple(): void {
        $values = [
            "one" => 5.8,
            "two" => 1.6,
            "three" => 5.6,
        ];
        $total = (int)ceil(array_sum($values));
        $calculated = calculateRoundingSpread($values);

        $this->assertEquals([
            "one" => 6,
            "two" => 2,
            "three" => 5,
        ], $calculated);
        $this->assertEquals($total, array_sum($calculated));
    }
}
