<?php

class Crossroads_PayEx_Model_Method_Masterpass extends Crossroads_PayEx_Model_Method_Abstract {
    protected $_code          = "crossroads_payex_masterpass";
    protected $_isOnline      = true;
    protected $_canCapture    = true;
    protected $_infoBlockType = "payex/info_invoice";
    // We do not allow refunds in Magento, this process is performed outside of Magento
    protected $_canRefund               = false;
    protected $_canVoid                 = false;
    protected $_canCancel               = false;

    public function getPayExInitializeAdditionalData($quote) {
        $data = parent::getPayExInitializeAdditionalData($quote);

        $data["USEMASTERPASS"] = 1;

        return $data;
    }

    public function getPayExViewParameter() {
        return "CREDITCARD";
    }

    /**
     * @param  Mage_Sales_Model_Order_Payment
     * @param  float
     * @return Mage_Payment_Model_Method_Abstract
     */
    public function capture(Varien_Object $payment, $amount) {
        $api      = Mage::getModel("payex/api");
        $order    = $payment->getOrder();
        $orderRef = $payment->getAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_ORDER_REF);

        if( ! $orderRef) {
            throw Crossroads_API_ResponseException::create(403, "Cannot perform payment finalization without order reference", null, 0);
        }

        try {
            $data = $api->finalizeTransaction($payment, $orderRef, $amount, 0); // 0 is from PayEx module

            $payment->setTransactionId($data["transactionNumber"]);
            $payment->setIsTransactionClosed(0);
            $payment->setAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_FINALIZE_RAW, $data["raw"]);
            $payment->setAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_PAYMENT_METHOD, $data["paymentMethod"]);
            $payment->setAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_TRANSACTION_NUMBER, $data["transactionNumber"]);
            $payment->setAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_TRANSACTION_STATUS, $data["transactionStatus"]);

            switch($data["transactionStatus"]) {
            case Crossroads_PayEx_Helper_Data::STATE_SALE:
            case Crossroads_PayEx_Helper_Data::STATE_CAPTURE:
                $payment->setIsTransactionPending(0);
                $payment->setIsTransactionClosed(1);
                break;
            case Crossroads_PayEx_Helper_Data::STATE_INITIALIZE:
                $payment->setIsTransactionPending(0);
                break;
            case Crossroads_PayEx_Helper_Data::STATE_AUTHORIZE:
                $payment->setIsTransactionPending(1);
                break;
            case Crossroads_PayEx_Helper_Data::STATE_CREDIT:
                break;
            case Crossroads_PayEx_Helper_Data::STATE_CANCEL:
            case Crossroads_PayEx_Helper_Data::STATE_FAILURE:
                $payment->save();
                throw new Exception("Failed transaction");
                break;
            }
        }
        catch(Exception $e) {
            Mage::helper("payex")->handleException($e, $order);
        }

        $payment->save();
        $order->save();
    }
}
