<?php

abstract class Crossroads_PayEx_Model_Method_Abstract extends Mage_Payment_Model_Method_Abstract {
    abstract public function getPayExViewParameter();

    public function isAvailable($quote = null) {
        if( ! $this->getConfigAccountNumber()) {
            return false;
        }

        return parent::isAvailable($quote);
    }

    /**
     * Returns the configured PayEx account number.
     */
    public function getConfigAccountNumber() {
        return $this->getConfigData("account_number");
    }

    /**
     * Returns the configured PayEx client language.
     */
    public function getConfigClientLanguage() {
        return $this->getConfigData("client_language");
    }

    /**
     * Returns the configured return URL to go to after success.
     */
    public function getConfigReturnUrl() {
        return $this->getConfigData("return_url");
    }

    /**
     * Returns the configured cancel url.
     */
    public function getConfigCancelUrl() {
        return $this->getConfigData("cancel_url");
    }

    /**
     * Returns the purchaseOperation option for the PayEx Initialize8 function.
     */
    public function getPurchaseOperation() {
        $action = $this->getConfigPaymentAction();

        switch($action) {
        case "authorize":
            return "AUTHORIZATION";
        case "authorize_capture":
            return "SALE";
        default:
            throw Exception(sprintf("%s: Invalid payment_action '%s'", __METHOD__, $action));
        }
    }

    public function getPayExOrderWsdl() {
        if($this->getConfigData("test")) {
            return "https://external.externaltest.payex.com/pxorder/pxorder.asmx?WSDL";
        }

        return "https://external.payex.com/pxorder/pxorder.asmx?WSDL";
    }

    public function calculateHash($requestData) {
        return strtoupper(md5(trim(implode("", $requestData)).$this->getConfigData("encryption_key")));
    }

    public function getPayExInitializeAdditionalData($quote) {
        return [
            "RESPONSIVE"      => 1,
            "SHOPPINGCARTXML" => $this->getShoppingCartXml($quote),
        ];
    }

    public function getShoppingCartXml($quote) {
        $xml      = new SimpleXMLElement("<ShoppingCart></ShoppingCart>");
        $currency = $quote instanceof Mage_Sales_Model_Order ? $quote->getOrderCurrencyCode() : $quote->getQuoteCurrencyCode();

        $xml->addChild("CurrencyCode", $currency);
        $xml->addChild("Subtotal", (int)(100 * $quote->getGrandTotal()));

        foreach($quote->getAllVisibleItems() as $i) {
            $prod = $i->getProduct();
            $qty  = $quote instanceof Mage_Sales_Model_Order ? $i->getQtyOrdered() : $i->getQty();
            $item = $xml->addChild("ShoppingCartItem");

            $item->addChild("Description", $item->getName());
            $item->addChild("Quantity", (float)$qty);
            $item->addChild("Value", (int)($prod->getFinalPrice() * 100));
            $item->addChild("ImageURL", $prod->getThumbnailUrl());
        }

        return $xml->asXML();
    }
}
