<?php

class Crossroads_PayEx_Helper_Data extends Mage_Core_Helper_Abstract {
    const STATE_SALE       = 0;
    const STATE_INITIALIZE = 1;
    const STATE_CREDIT     = 2;
    const STATE_AUTHORIZE  = 3;
    const STATE_CANCEL     = 4;
    const STATE_FAILURE    = 5;
    const STATE_CAPTURE    = 6;

    public function stateToString($state) {
        switch($state) {
        case self::STATE_SALE:
            return "SALE";
        case self::STATE_INITIALIZE:
            return "INITIALIZE";
        case self::STATE_CREDIT:
            return "CREDIT";
        case self::STATE_AUTHORIZE:
            return "AUTHORIZE";
        case self::STATE_CANCEL:
            return "CANCEL";
        case self::STATE_FAILURE:
            return "FAILURE";
        case self::STATE_CAPTURE:
            return "CAPTURE";
        }
    }

    public function handleException($e, $order) {
        switch($e->payexCode) {
        case "Order_NoDeliveryAddressExist":
            // We might have a canceled order, check that
            $info = Mage::getModel("payex/api")->checkTransaction($order);

            switch($nfo["transactionStatus"]) {
            case 1:
                throw Crossroads_API_ResponseException::create(400, "PayEx transaction is in the initialize phase");
            case 0:
            case 2:
            case 3:
            case 6:
                throw Crossroads_API_ResponseException::create(400, "Attempting to reuse a payex transaction");
            case 5:
                throw Crossroads_API_ResponseException::create(400, "PayEx order is canceled");
            }

            throw Crossroads_API_ResponseException::create(404, "PayEx does not have any address for the order", null, 13002);
        case "CreditCard_Error":
            Mage::logException($e);
            switch($e->thirdPartyError) {
                case "REJECTED_BY_ACQUIRER":
                    throw Crossroads_API_ResponseException::create(403, "Rejected by acquirer", null, 13003);
                case "REJECTED_BY_ACQUIRER_INSUFFICIENT_FUNDS":
                    throw Crossroads_API_ResponseException::create(403, "Rejected by acquirer due to insufficient funds", null, 13004);
                case "REJECTED_BY_ACQUIRER_CARD_BLACKLISTED":
                    throw Crossroads_API_ResponseException::create(403, "Rejected by acquirer due to card being blacklisted", null, 13005);
            }
        default:
            throw $e;
        }
    }
}
