<?php

class Crossroads_PayEx_Controller_Masterpass extends Crossroads_API_Controller_Super {
    const POST_LOAD_ADDRESS = "crossroads_payex_masterpass_post_load_address";

    /**
     * @api {post} /payment/crossroads_payex_masterpass/init Start masterpass session
     * @apiName payment_crossroads_payex_masterpass_init
     */
    public function initAction() {
        $checkout = $this->getCheckoutSession();
        $helper   = Mage::helper("payex/masterpass");

        $quote = $checkout->getQuote();

        return $this->sendData([200, [
            "redirectUrl" => $helper->initializeMasterpass($quote)
        ]]);
    }

    public function load_addressAction() {
        $checkout = $this->getCheckoutSession();
        $helper   = Mage::helper("payex/masterpass");

        $quote = $checkout->getQuote();

        $helper->loadAddress($quote);

        $resp = new Varien_Object([
            "code"          => 204,
            "response_data" => null,
        ]);

        Mage::dispatchEvent(self::POST_LOAD_ADDRESS, [
            "quote"    => $quote,
            "response" => $resp
        ]);

        return [$resp->getCode(), $resp->getResponseData()];
    }
}
