<?php

class Crossroads_PayEx_Helper_Masterpass extends Mage_Core_Helper_Abstract {
    const FIELD_ORDER_REF          = "payex_masterpass_order_ref";
    const FIELD_FINALIZE_RAW       = "payex_masterpass_finalize_raw";
    const FIELD_TRANSACTION_STATUS = "payex_masterpass_transaction_status";
    const FIELD_TRANSACTION_NUMBER = "payex_masterpass_transaction_number";
    const FIELD_PAYMENT_METHOD     = "payex_masterpass_payment_method";

    /**
     * @param  Mage_Sales_Model_Quote
     * @throws Crossroads_API_ResponseException
     */
    public function initializeMasterPass($quote) {
        $api = Mage::getModel("payex/api");

        try {
            $quote->removePayment();
            $quote->setPaymentMethod("crossroads_payex_masterpass");
            $quote->getPayment()->importData([ "method" => "crossroads_payex_masterpass" ]);

            $quote->collectTotals();

            if( ! $quote || ! $quote->hasItems() || $quote->getGrandTotal() < 0.01) {
                // TODO: Error code
                throw Crossroads_API_ResponseException::create(400, "Cannot use masterpass with an empty or free cart.", null, 13000);
            }

            $quote->reserveOrderId()->save();
        }
        catch(Mage_Core_Exception $e) {
            Mage::logException($e);

            // FIXME
            throw $e;
        }

        list($orderRef, $redirectUrl) = $api->initialize8($quote);

        $quote->getPayment()->setAdditionalInformation(self::FIELD_ORDER_REF, $orderRef);
        $quote->getPayment()->save();
        $quote->save();

        return $redirectUrl;
    }

    public function loadAddress($quote) {
        $api         = Mage::getModel("payex/api");
        $paymentInfo = $quote->getPayment();
        $orderRef    = $paymentInfo->getAdditionalInformation(self::FIELD_ORDER_REF);

        if( ! $orderRef) {
            throw Crossroads_API_ResponseException::create(400, "No PayEx order reference present, make sure init has been called and the cart has not been modified", null, 13001);
        }

        try {
            $address = $api->getApprovedDeliveryAddress($paymentInfo, $orderRef);
        }
        catch(Exception $e) {
            switch($e->payexCode) {
            case "Order_NoDeliveryAddressExist":
                throw Crossroads_API_ResponseException::create(404, "PayEx does not have any address for the order", null, 13002);
            case "CreditCard_Error":
                Mage::logException($e);
                switch($e->thirdPartyError) {
                    case "REJECTED_BY_ACQUIRER":
                        throw Crossroads_API_ResponseException::create(403, "Rejected by acquirer", null, 13003);
                    case "REJECTED_BY_ACQUIRER_INSUFFICIENT_FUNDS":
                        throw Crossroads_API_ResponseException::create(403, "Rejected by acquirer due to insufficient funds", null, 13004);
                    case "REJECTED_BY_ACQUIRER_CARD_BLACKLISTED":
                        throw Crossroads_API_ResponseException::create(403, "Rejected by acquirer due to card being blacklisted", null, 13005);
                }
            default:
                throw $e;
            }
        }

        $quote->removeAllAddresses();

        $quote->setBillingAddress(Mage::getModel("sales/quote_address")
            ->setData($address)
            ->setSaveInAddressBook(0));
        $quote->setShippingAddress(Mage::getModel("sales/quote_address")
            ->setData($address)
            ->setSaveInAddressBook(0)
            ->setCollectShippingRates(true));

        $quote->setCustomerEmail($address["email"]);

        $quote->save();
    }
}
