<?php

class Crossroads_PayEx_Block_Info_Invoice extends Mage_Payment_Block_Info {
    protected function _prepareSpecificInformation($transport = null) {
        if($this->_paymentSpecificInformation) {
            return $this->_paymentSpecificInformation;
        }

        $helper  = Mage::helper("payex");
        $payment = $this->getInfo();

        $transport = new Varien_Object();
        $transport = parent::_prepareSpecificInformation($transport);

        if(Mage::getDesign()->getArea() === "adminhtml") {
            switch($payment->getMethod()) {
            case "crossroads_payex_masterpass":
                if($payment->hasAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_TRANSACTION_STATUS)) {
                    $transport->addData([
                        $helper->__("Transaction Status") => sprintf(
                            "%s (%d)",
                            $helper->stateToString($payment->getAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_TRANSACTION_STATUS)),
                            $payment->getAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_TRANSACTION_STATUS)
                        ),
                    ]);
                }

                $transport->addData([
                    $helper->__("Order Reference") => $payment->getAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_ORDER_REF),
                    $helper->__("Transaction Raw") => $payment->getAdditionalInformation(Crossroads_PayEx_Helper_Masterpass::FIELD_FINALIZE_RAW),
                ]);

                break;
            }
        }

        return $transport;
    }
}
